-- Commerce_Finisher.lua
-- Author: Machiavelli
-- DateCreated: 5/30/2012 12:34:39 PM
--------------------------------------------------------------
function CommerceFinisher(playerID)
	local player = Players[playerID];
	local policyID = GameInfoTypes["POLICY_COMMERCE_FINISHER"];

	-- Only run this if the player has the commerce finisher policy 
	if (player:HasPolicy(policyID) and not player:IsPolicyBlocked(policyID)) then
		-- Get current gold before adding the gold per turn.  Make sure it isn't negative.
		local currentGold = player:GetGold() - player:CalculateGoldRate();
		-- Adjust the threshold by gamespeed
		local goldThreshold = 1000;
		local speedGoldPercent = GameInfo.GameSpeeds[Game:GetGameSpeedType()].GoldPercent;
		local adjustedGoldThreshold = (goldThreshold * speedGoldPercent) / 100;

		-- Only get a bonus if the player has less than adjustedGoldThreshold
		if(currentGold < adjustedGoldThreshold) then
			local maxBonusGold = 100;
			local percentToGiveTimes100 = ((adjustedGoldThreshold - currentGold) * 100) / adjustedGoldThreshold;
			local bonusGold = math.floor((maxBonusGold * percentToGiveTimes100) / 100);

			-- Give the gold
			player:SetGold(player:GetGold() + bonusGold);

			-- Send a notification to the player
			local text = Locale.ConvertTextKey("TXT_KEY_GOLD_FROM_COMMERCE_FINISHER", tostring(bonusGold));
			player:AddNotification(NotificationTypes.NOTIFICATION_GENERIC, text, text);
		end
	end
end
GameEvents.PlayerDoTurn.Add(CommerceFinisher);
